# 🔥 COMPLETE FIX: Paths + Permissions

## Your Errors:
```
❌ GET https://adekay.com/forexcalc1/app.js 403 (Forbidden)
❌ GET https://adekay.com/sw.js 404 (Not Found)
❌ GET https://adekay.com/icon-192.png 404 (Not Found)
```

## 🎯 The Problems:
1. **403 on app.js** = Wrong file permissions
2. **404 on sw.js & icons** = Wrong paths (looking in root instead of /forexcalc1/)

---

## ✅ COMPLETE SOLUTION (5 Minutes)

### STEP 1: Download Updated Files (IMPORTANT!)

I just fixed all the paths! Download these NEW versions:

**Required Files (All paths now fixed!):**
1. **index.html** - Updated with relative paths
2. **sw-register.js** - Fixed service worker path
3. **sw.js** - Fixed cache paths
4. **manifest.webmanifest** - Fixed icon paths
5. **app.js** - (no change needed)
6. **styles.css** - (no change needed)
7. **icon-192.png** - (no change needed)
8. **icon-512.png** - (no change needed)

**Also download:**
9. **.htaccess-emergency** - To fix permissions

---

### STEP 2: Delete Everything in /forexcalc1/

**Via cPanel File Manager:**
1. Navigate to `/forexcalc1/` folder
2. Select ALL files and folders inside
3. Click **Delete**
4. Confirm deletion

**Why?** Old files have wrong paths. Fresh start is cleanest!

---

### STEP 3: Upload NEW Files

**Upload these 9 files to `/forexcalc1/`:**

1. `index.html` (or use `index-no-inline.html` renamed)
2. `sw-register.js` (if using index-no-inline version)
3. `app.js`
4. `styles.css`
5. `sw.js`
6. `manifest.webmanifest`
7. `icon-192.png`
8. `icon-512.png`
9. `.htaccess-emergency` (rename to `.htaccess`)

**File structure should be:**
```
/public_html/forexcalc1/
├── .htaccess
├── index.html
├── app.js
├── styles.css
├── sw.js
├── sw-register.js (if using no-inline version)
├── manifest.webmanifest
├── icon-192.png
└── icon-512.png
```

---

### STEP 4: Set Permissions (CRITICAL!)

**Via cPanel File Manager:**

1. Right-click **forexcalc1 folder** → Permissions → Enter: **755**
2. Go INSIDE the folder
3. Select **ALL FILES** → Right-click → Permissions → Enter: **644**
4. Make sure to check **all files** including `.htaccess`

**Correct Permissions:**
```
forexcalc1/              755 (drwxr-xr-x)
├── .htaccess            644 (-rw-r--r--)
├── index.html           644 (-rw-r--r--)
├── app.js               644 (-rw-r--r--)
├── styles.css           644 (-rw-r--r--)
├── sw.js                644 (-rw-r--r--)
├── sw-register.js       644 (-rw-r--r--)
├── manifest.webmanifest 644 (-rw-r--r--)
├── icon-192.png         644 (-rw-r--r--)
└── icon-512.png         644 (-rw-r--r--)
```

---

### STEP 5: Clear Cache & Test

1. **Clear browser cache:** Ctrl+Shift+Delete → "All time" → Clear
2. **Close all tabs** with your site
3. **Open new incognito window:** Ctrl+Shift+N
4. **Visit:** `https://adekay.com/forexcalc1/`

---

## 🎯 What Was Fixed:

### Path Fixes:
**Before (WRONG):**
```javascript
// Looking in root directory
register('/sw.js')           ❌
src="/app.js"                ❌
href="/icon-192.png"         ❌
```

**After (CORRECT):**
```javascript
// Looking in current directory (forexcalc1/)
register('./sw.js')          ✅
src="app.js"                 ✅
href="icon-192.png"          ✅
```

### Permission Fixes:
- Folder: 755 (execute permission allows browsing)
- Files: 644 (readable by everyone)
- .htaccess: Explicitly allows access

---

## 📋 Verification Checklist

After uploading, verify:

- [ ] All 9 files in `/forexcalc1/` ✅
- [ ] Folder permission = 755 ✅
- [ ] All file permissions = 644 ✅
- [ ] Browser cache cleared ✅
- [ ] Testing in incognito mode ✅

**Open Console (F12) - Should see:**
```
✅ [SW] Service worker registered
✅ Calculator ready!
❌ NO 403 errors
❌ NO 404 errors
```

---

## ✅ SUCCESS INDICATORS

**Visual:**
- ✅ Calculator loads completely
- ✅ Beautiful gradient background
- ✅ FX logo animates
- ✅ Input fields work
- ✅ Dropdowns work (including symbols!)

**Console:**
- ✅ No red errors
- ✅ Service worker registered
- ✅ All files load (200 OK)

**Functionality:**
- ✅ Can select symbols from dropdown
- ✅ Calculations update live
- ✅ Toast notifications appear
- ✅ BUY/SELL banner changes

---

## 🔧 If Symbols Dropdown Still Not Working

**After fixing paths and permissions:**

1. **Hard refresh:** Ctrl+F5
2. **Check console:** Any errors on app.js?
3. **Verify app.js loaded:**
   - Open Network tab (F12)
   - Reload page
   - Find `app.js`
   - Should show: `200 OK` and file size `16KB`

**If app.js still shows 403:**
- Permissions not set correctly
- Double-check file permission is **644**
- Try chmod via SSH: `chmod 644 app.js`

**If app.js loads but dropdown doesn't populate:**
- Check console for JavaScript errors
- Look for: `CATALOG` object errors
- Verify `populateSymbols()` function runs

---

## 🆘 Emergency Contact Template

If still having issues, email your host:

```
Subject: URGENT - 403 & 404 Errors After Upload

URL: https://adekay.com/forexcalc1/

Issues:
1. app.js shows 403 Forbidden
2. Dropdown not working (app.js not loading)

What I've done:
✅ Uploaded fresh files with correct relative paths
✅ Set folder permission: 755
✅ Set all file permissions: 644
✅ Uploaded .htaccess with Allow from all
✅ Cleared all caches
✅ Tested in incognito mode

Please check:
1. Is ModSecurity blocking .js files?
2. Any server rules blocking JavaScript?
3. File ownership correct? (should be my username)
4. Any .htaccess in parent directory blocking?

Files are standard HTML/CSS/JS - no malicious code.

URGENT: Calculator won't work without app.js loading.

Thank you!
```

---

## 📊 Quick Diagnosis

**Error Type → Solution:**

| Error | Cause | Fix |
|-------|-------|-----|
| `403 on app.js` | Wrong permissions | Set to 644 |
| `404 on sw.js` | Wrong path | Use updated files |
| `404 on icons` | Wrong path | Use updated files |
| `Dropdown not working` | app.js not loaded | Fix 403 first |

---

## 💡 Why This Happens

**Subdirectory Issue:**
- Your site: `adekay.com/forexcalc1/`
- Old paths: `/sw.js` (looks in `adekay.com/sw.js`) ❌
- New paths: `./sw.js` or `sw.js` (looks in `adekay.com/forexcalc1/sw.js`) ✅

**Permission Issue:**
- 755 = Folder browsable
- 644 = Files readable
- Without these, server blocks access (403)

---

## 🎯 TL;DR

1. **Delete old files**
2. **Upload NEW files** (I just fixed the paths!)
3. **Set permissions:** 755 folder, 644 files
4. **Clear cache** completely
5. **Test in incognito**

**Everything should work now!** 🚀

---

## 📱 Test Checklist

Go through these one by one:

1. **Page loads?** ✅
2. **Background gradient visible?** ✅
3. **Can type in Balance field?** ✅
4. **Symbol dropdown has options?** ✅ ← This confirms app.js loaded!
5. **Calculations work?** ✅
6. **Toast appears when clicking buttons?** ✅
7. **Console has no errors?** ✅

If ALL checked ✅ = **SUCCESS!** 🎉

---

**The key fix: Use the updated files with relative paths + correct permissions!**
