// Service Worker Registration - Separate file for CSP compliance
(function() {
  'use strict';
  
  // Service Worker Registration with update handling
  if ('serviceWorker' in navigator) {
    window.addEventListener('load', async () => {
      try {
        const registration = await navigator.serviceWorker.register('./adekaycal/forexcalc1/sw.js');
        console.log('[SW] Service worker registered:', registration);
        
        // Check for updates
        registration.addEventListener('updatefound', () => {
          const newWorker = registration.installing;
          if (newWorker) {
            newWorker.addEventListener('statechange', () => {
              if (newWorker.state === 'installed' && navigator.serviceWorker.controller) {
                console.log('[SW] New version available');
                // Show toast if available
                if (typeof showToast === 'function') {
                  showToast('New version available! Reload to update.', 'info');
                }
              }
            });
          }
        });
      } catch (error) {
        console.error('[SW] Service worker registration failed:', error);
      }
    });
  } else {
    console.warn('[SW] Service workers are not supported in this browser');
  }
})();
