# 🔧 ONE-PAGE FIX: Remove 403 Forbidden

## ⚡ THE PROBLEM
```
❌ GET https://adekay.com/forexcalc1/index.html 403 (Forbidden)
```

## ✅ THE SOLUTION (3 Minutes)

---

### STEP 1: Fix Permissions (MOST IMPORTANT!)

**Via cPanel File Manager:**

1. Go to **File Manager**
2. Navigate to `/forexcalc1/` folder
3. Right-click the **FOLDER** → Permissions → Enter: **755**
4. Right-click **ALL FILES** → Permissions → Enter: **644**
5. Click Apply

**Visual Guide:**
```
✅ Correct Permissions:

forexcalc1/              755 (drwxr-xr-x)
├── index.html           644 (-rw-r--r--)
├── app.js               644 (-rw-r--r--)
├── styles.css           644 (-rw-r--r--)
├── sw.js                644 (-rw-r--r--)
├── sw-register.js       644 (-rw-r--r--)
├── manifest.webmanifest 644 (-rw-r--r--)
├── icon-192.png         644 (-rw-r--r--)
└── icon-512.png         644 (-rw-r--r--)
```

---

### STEP 2: Upload Emergency .htaccess

**Download:** `.htaccess-emergency`
**Rename to:** `.htaccess`
**Upload to:** `/forexcalc1/` folder

**This file contains 4 lines:**
```apache
<FilesMatch ".*">
    Order allow,deny
    Allow from all
</FilesMatch>
```

---

### STEP 3: Clear Cache & Test

1. **Clear browser cache:** Ctrl+Shift+Delete → Select "All time"
2. **Hard refresh:** Ctrl+F5
3. **Test in incognito:** Ctrl+Shift+N
4. **Go to:** https://adekay.com/forexcalc1/

---

## 📋 QUICK CHECKLIST

- [ ] Folder permission = 755 ✅
- [ ] All files permission = 644 ✅
- [ ] Uploaded .htaccess-emergency ✅
- [ ] Cleared browser cache ✅
- [ ] Tested in incognito mode ✅

---

## 🚨 IF STILL DOESN'T WORK

**Email your hosting support:**

```
Subject: 403 Error - Need Permissions Fix

I'm getting 403 Forbidden on:
https://adekay.com/forexcalc1/index.html

I've set:
- Folder: 755
- Files: 644
- Uploaded .htaccess allowing access

Please check:
1. ModSecurity rules
2. Server-level blocks
3. File ownership

Thank you!
```

---

## 📁 DOWNLOAD THESE FILES

**Upload to /forexcalc1/ with 644 permissions:**
1. `.htaccess-emergency` (rename to `.htaccess`)
2. `index-no-inline.html` (rename to `index.html`)
3. `sw-register.js`
4. `app.js`
5. `styles.css`
6. `sw.js`
7. `manifest.webmanifest`
8. `icon-192.png`
9. `icon-512.png`

---

## ✅ SUCCESS LOOKS LIKE

**Browser:**
- ✅ Calculator loads (no 403!)
- ✅ Pretty gradients visible
- ✅ Can type in fields

**Console (F12):**
- ✅ No red errors
- ✅ "Service worker registered"

---

## 📊 WHAT THESE PERMISSIONS MEAN

**755 (Folder):**
- 7 = Owner: Read+Write+Execute
- 5 = Group: Read+Execute
- 5 = Public: Read+Execute
- **Result:** Everyone can read, owner can modify

**644 (Files):**
- 6 = Owner: Read+Write
- 4 = Group: Read
- 4 = Public: Read
- **Result:** Everyone can read, owner can modify

---

## 🎯 WHY 403 HAPPENS

**Common Causes:**
1. **Wrong permissions** ← 70% of cases
2. **ModSecurity blocking** ← 15%
3. **Wrong file ownership** ← 10%
4. **Parent .htaccess blocking** ← 3%
5. **Server config** ← 2%

**The Fix:**
- Set correct permissions (755/644)
- Upload .htaccess allowing access
- Contact host if still broken

---

## 🔑 KEY POINTS

- ✅ **755 for folders** - Must have execute permission
- ✅ **644 for files** - Must be readable by everyone
- ✅ **.htaccess** - Must allow access
- ✅ **Clear cache** - Old restrictions cached

---

**Print this page and follow step-by-step!** 📄

**Questions? Read: REMOVE-403-FORBIDDEN.md** 📚
