# 🎯 SNIPER ENGINE 3.0 - PWA DEPLOYMENT GUIDE

## ✨ What's New in This Version

### 🎨 Improved Design
- **Modern Dark Theme**: Beautiful gradient background with subtle animations
- **Better Readability**: Larger, clearer pair names with improved contrast
- **Vibrant Colors**: Eye-catching signal indicators with glow effects
- **Responsive Layout**: Perfect on all devices (mobile, tablet, desktop)

### 📱 PWA Features
- **Install on Mobile**: Add to home screen for app-like experience
- **Offline Support**: View cached data even without internet
- **Push Notifications**: Get alerted when signals trigger
- **Fast Loading**: Optimized caching for instant access

### 🎯 Key Improvements
1. **Pair Names**: Now using JetBrains Mono font at 1.5rem with text shadow
2. **Color Scheme**: Professional gradient backgrounds with neon accents
3. **Signal Badges**: Animated glow effects for BUY/SELL signals
4. **Data Display**: Clean grid layout with icons and hover effects
5. **Status Indicators**: Live connection status with animated dots

---

## 📦 FILES TO UPLOAD

Make sure ALL these files are in your `/public_html/snipper_project/` folder:

```
snipper_project/
├── app.py                 ✅ (Updated)
├── passenger_wsgi.py      ✅ (Keep existing)
├── sniper_engine.py       ✅ (Keep existing)
├── requirements.txt       ✅ (Keep existing)
├── .htaccess             ✅ (Keep existing)
├── templates/
│   └── index.html        ✅ (NEW - Replace old version)
├── manifest.json         ✅ (NEW - Replace old version)
└── sw.js                 ✅ (NEW - Replace old version)
```

---

## 🚀 DEPLOYMENT STEPS

### Step 1: Create Templates Folder
```bash
# In cPanel File Manager or via SSH:
mkdir -p /home/adekayco/public_html/snipper_project/templates
```

### Step 2: Upload Files
Upload these NEW files:
- `index.html` → **templates/index.html** (Important: Inside templates folder!)
- `manifest.json` → Root of snipper_project/
- `sw.js` → Root of snipper_project/
- `app.py` → Root of snipper_project/ (Replace existing)

### Step 3: Verify File Structure
Your folder should look like:
```
snipper_project/
├── app.py
├── passenger_wsgi.py
├── sniper_engine.py
├── requirements.txt
├── .htaccess
├── manifest.json          ← NEW
├── sw.js                  ← NEW
└── templates/
    └── index.html         ← NEW (Inside templates folder!)
```

### Step 4: Restart Python App
1. Go to cPanel → **Setup Python App**
2. Find your `snipper_project` application
3. Click **RESTART** button (Very important!)
4. Wait 10-15 seconds for restart to complete

### Step 5: Clear Browser Cache
1. Open your browser
2. Press `Ctrl + Shift + Delete` (or `Cmd + Shift + Delete` on Mac)
3. Clear cache and cookies
4. Close and reopen browser

### Step 6: Test the App
1. Visit: `https://yourdomain.com/snipper_project/`
   - ⚠️ Make sure URL ends with `/`
2. You should see the new modern dark design
3. Check browser console (F12) for any errors

---

## 📱 INSTALLING AS PWA ON MOBILE

### For Android (Chrome/Edge/Samsung Internet):

1. **Visit the Site**
   - Open `https://yourdomain.com/snipper_project/` in Chrome

2. **Install Prompt**
   - You should see a banner: "Install Sniper Engine"
   - OR tap the 3-dot menu → "Install app" or "Add to Home screen"

3. **Grant Permissions**
   - Allow notifications (optional but recommended)
   - Allow installation

4. **Launch**
   - Icon will appear on home screen
   - Opens in full-screen app mode (no browser UI)

### For iOS (Safari):

1. **Visit the Site**
   - Open `https://yourdomain.com/snipper_project/` in Safari

2. **Add to Home Screen**
   - Tap the Share button (square with arrow)
   - Scroll down and tap "Add to Home Screen"
   - Edit name if desired, tap "Add"

3. **Launch**
   - Icon appears on home screen
   - Opens like a native app

---

## 🔧 TROUBLESHOOTING

### ❌ Problem: "404 Not Found" Error

**Solution:**
1. Check URL ends with `/`: `https://yourdomain.com/snipper_project/`
2. Verify `index.html` is inside `templates/` folder
3. Restart Python app in cPanel
4. Check file permissions (should be 644 for files, 755 for folders)

### ❌ Problem: "Connection Failed" Error

**Solution:**
1. Check Python app is running in cPanel
2. Verify all dependencies installed: `pip install -r requirements.txt --break-system-packages`
3. Check error logs: cPanel → Python App → View Logs
4. Ensure `app.py` has `application = app` at the end

### ❌ Problem: Can't Install PWA

**Solution:**
1. Verify `manifest.json` and `sw.js` are in root folder
2. Check browser console (F12) for service worker errors
3. Must use HTTPS (PWA requires secure connection)
4. Clear browser cache and try again
5. Check that files are served with correct MIME types:
   - `manifest.json` → `application/manifest+json`
   - `sw.js` → `application/javascript`

### ❌ Problem: Old Design Still Showing

**Solution:**
1. Hard refresh: `Ctrl + Shift + R` (or `Cmd + Shift + R` on Mac)
2. Clear browser cache completely
3. Try in incognito/private window
4. Unregister old service worker:
   - F12 → Application → Service Workers → Unregister
5. Make sure you replaced the OLD index.html with the NEW one

### ❌ Problem: API Not Working

**Solution:**
1. Check `sniper_engine.py` has no syntax errors
2. Verify yfinance is working: Test with `python sniper_engine.py`
3. Check API endpoint: Visit `https://yourdomain.com/snipper_project/api/scan`
4. Should return JSON data, not HTML error page

---

## 🎨 CUSTOMIZATION OPTIONS

### Change Colors
Edit the CSS variables in `templates/index.html`:
```css
:root {
    --bg-primary: #0a0e1a;        /* Main background */
    --accent-green: #00ff88;       /* Buy signal color */
    --accent-red: #ff3366;         /* Sell signal color */
    --accent-yellow: #ffcc00;      /* Wait signal color */
    --accent-blue: #00d4ff;        /* Accent elements */
}
```

### Change Fonts
Replace in `<head>` section:
```html
<link href="https://fonts.googleapis.com/css2?family=YourFont:wght@400;600&display=swap" rel="stylesheet">
```

### Adjust Scan Interval
In `app.py`, change the minutes:
```python
scheduler.add_job(func=scheduled_job, trigger="interval", minutes=15)  # Change 15 to desired minutes
```

---

## 📊 TESTING CHECKLIST

- [ ] Files uploaded to correct locations
- [ ] `index.html` is inside `templates/` folder
- [ ] Python app restarted in cPanel
- [ ] Browser cache cleared
- [ ] Site loads with new design
- [ ] API returns data: `/api/scan` works
- [ ] Service worker registers (check F12 → Console)
- [ ] Manifest loads (check F12 → Application → Manifest)
- [ ] Install banner appears on mobile
- [ ] Can install as PWA
- [ ] Notifications work (if enabled)
- [ ] Offline mode works (try with airplane mode)

---

## 🔐 SECURITY NOTES

⚠️ **Important**: Your `app.py` contains credentials in plain text!

**Recommended Action:**
Move credentials to environment variables:

```python
# In app.py, replace hardcoded values with:
import os

TELEGRAM_TOKEN = os.environ.get('TELEGRAM_TOKEN', 'your_token_here')
TELEGRAM_CHAT_ID = os.environ.get('TELEGRAM_CHAT_ID', 'your_chat_id')
EMAIL_SENDER = os.environ.get('EMAIL_SENDER', 'your_email@gmail.com')
EMAIL_PASSWORD = os.environ.get('EMAIL_PASSWORD', 'your_app_password')
```

Then set environment variables in cPanel → Python App → Environment Variables

---

## 📞 SUPPORT

If you encounter issues:

1. **Check Logs**: cPanel → Python App → View Application Logs
2. **Browser Console**: Press F12 → Console tab
3. **Test API Directly**: Visit `/api/scan` in browser
4. **Verify File Paths**: Make sure templates/ folder exists

---

## 🎉 SUCCESS INDICATORS

You'll know it's working when:

✅ Modern dark gradient design appears
✅ Pair names are large and clearly readable
✅ Signals have animated glow effects
✅ Status indicator pulses in top-right
✅ Install banner shows on mobile
✅ Can add to home screen
✅ Works offline (shows cached data)
✅ Notifications appear for new signals

---

## 📝 VERSION HISTORY

**v4.0** (Current)
- Complete design overhaul
- PWA installation support
- Improved mobile experience
- Better color scheme
- Enhanced readability

**v3.0** (Previous)
- Basic functionality
- Simple design
- No PWA support

---

**Deployed Successfully?** 🎉
Now you can access your trading dashboard anywhere, anytime!
