from flask import Flask, render_template, jsonify, send_from_directory, make_response
from sniper_engine import check_sniper_conditions
from apscheduler.schedulers.background import BackgroundScheduler
import requests
import smtplib
from email.mime.text import MIMEText
import logging
import sys
import os

# Configure Logging
logging.basicConfig(stream=sys.stderr, level=logging.INFO)
logger = logging.getLogger('SniperApp')

app = Flask(__name__)

# --- CREDENTIALS ---
TELEGRAM_TOKEN = "8238832364:AAGW51FG4KlL1prIH06_mkhdG0ZvpVs6_f0"
TELEGRAM_CHAT_ID = "6984434604"
EMAIL_SENDER = "adekolagafat@gmail.com"
EMAIL_PASSWORD = "qwzc avdh fzpi osea"
EMAIL_RECEIVER = "adekolagafat@gmail.com"

# Cache results
latest_scan_results = []

def send_telegram(message):
    if "YOUR_BOT" in TELEGRAM_TOKEN: return
    url = f"https://api.telegram.org/bot{TELEGRAM_TOKEN}/sendMessage"
    try:
        requests.post(url, data={"chat_id": TELEGRAM_CHAT_ID, "text": message}, timeout=10)
    except Exception as e:
        logger.error(f"Telegram Failed: {e}")

def send_email(subject, body):
    if "your_email" in EMAIL_SENDER: return
    msg = MIMEText(body)
    msg['Subject'] = subject
    msg['From'] = EMAIL_SENDER
    msg['To'] = EMAIL_RECEIVER
    try:
        with smtplib.SMTP_SSL('smtp.gmail.com', 465) as server:
            server.login(EMAIL_SENDER, EMAIL_PASSWORD)
            server.send_message(msg)
    except Exception as e:
        logger.error(f"Email Failed: {e}")

def scheduled_job():
    global latest_scan_results
    logger.info("Starting scheduled scan...")
    try:
        results = check_sniper_conditions()
        latest_scan_results = results
        
        for item in results:
            if "SNIPER" in item['signal']:
                alert_msg = (f"🎯 {item['pair']} ALERT 🎯\n\n"
                             f"Signal: {item['signal']}\n"
                             f"Reason: {item['reason']}\n"
                             f"Price: {item['data'].get('Price', 'N/A')}\n"
                             f"Time: {item['timestamp']}")
                send_telegram(alert_msg)
                send_email(f"Sniper Alert: {item['pair']}", alert_msg)
    except Exception as e:
        logger.error(f"Scan failed: {e}")

# Start Scheduler
try:
    scheduler = BackgroundScheduler()
    scheduler.add_job(func=scheduled_job, trigger="interval", minutes=15)
    scheduler.start()
except Exception as e:
    logger.error(f"Scheduler failed: {e}")

# --- ROUTES ---

@app.route('/')
def index():
    """Serve the main page"""
    return render_template('index.html')

@app.route('/api/scan')
def scan_api():
    """Return latest scan results"""
    if not latest_scan_results:
        scheduled_job()
    return jsonify(latest_scan_results)

@app.route('/api/force_scan')
def force_scan():
    """Force a new scan immediately"""
    scheduled_job()
    return jsonify(latest_scan_results)

# --- PWA ROUTES ---
@app.route('/manifest.json')
def manifest():
    """Serve the PWA manifest with proper headers"""
    response = make_response(send_from_directory('.', 'manifest.json'))
    response.headers['Content-Type'] = 'application/manifest+json'
    response.headers['Cache-Control'] = 'public, max-age=0'
    return response

@app.route('/sw.js')
def service_worker():
    """Serve the service worker with proper headers"""
    response = make_response(send_from_directory('.', 'sw.js'))
    response.headers['Content-Type'] = 'application/javascript'
    response.headers['Cache-Control'] = 'public, max-age=0'
    response.headers['Service-Worker-Allowed'] = '/'
    return response

# --- ERROR HANDLERS ---
@app.errorhandler(404)
def not_found(error):
    """Custom 404 error page"""
    return jsonify({
        'error': '404 Not Found',
        'message': 'The requested resource was not found on this server.'
    }), 404

@app.errorhandler(500)
def internal_error(error):
    """Custom 500 error page"""
    logger.error(f"Internal server error: {error}")
    return jsonify({
        'error': '500 Internal Server Error',
        'message': 'An internal error occurred. Please try again later.'
    }), 500

# --- HEALTH CHECK ---
@app.route('/health')
def health():
    """Health check endpoint"""
    return jsonify({
        'status': 'healthy',
        'scheduler_running': scheduler.running if 'scheduler' in globals() else False,
        'latest_results_count': len(latest_scan_results)
    })

# Required for cPanel/Passenger
application = app

if __name__ == '__main__':
    app.run(debug=False, host='0.0.0.0', port=5000)
