# 🚀 Livermore Scanner - Jupiter Hosting Setup
## (Control Panel Only - No SSH Required)

---

## ⚡ SUPER QUICK START (5 STEPS)

### 1️⃣ Upload Files
- Login to Jupiter Control Panel
- File Manager → `public_html/` → Create folder `livermore`
- Upload ALL Python files to `/livermore/`

### 2️⃣ Setup Python App
- Control Panel → "Setup Python App"
- App Root: `/home/yourusername/public_html/livermore`
- URL: `adekay.com/livermore`
- Startup File: `passenger_wsgi.py`
- Install packages: `Flask flask-cors pandas numpy ccxt python-dotenv`

### 3️⃣ Configure .env
- File Manager → `/livermore/` → Create file `.env`
- Add your email, telegram, API keys

### 4️⃣ Add Cron Job
- Control Panel → "Cron Jobs"
- Add: `touch /home/yourusername/public_html/livermore/tmp/restart.txt`
- Schedule: Daily at 4 AM

### 5️⃣ Start App
- File Manager → `/livermore/tmp/` → Create empty file `restart.txt`
- Visit: `http://adekay.com/livermore`
- ✅ **DONE!**

---

## 📋 DETAILED STEP-BY-STEP

### **STEP 1: Upload Files**

**1.1 Login to Jupiter Control Panel**
- Go to your hosting dashboard
- Find "File Manager" (usually has a folder icon 📁)

**1.2 Navigate and Create Folder**
```
public_html/ → [New Folder] → Name it: livermore
```

**1.3 Upload These Files to `/livermore/`:**
```
✅ app.py
✅ scanner.py
✅ indicators.py
✅ murrey.py
✅ unified_connector.py
✅ telegram_notifier.py
✅ email_notifier.py
✅ mt5_connector.py
✅ broker_configs.py
✅ pair_classifier.py
✅ crypto_connector.py
✅ exchange_configs.py
✅ crypto_classifier.py
✅ dashboard.html
✅ scanner.css
✅ requirements.txt
✅ passenger_wsgi.py (from this deployment package)
✅ .htaccess (from this deployment package)
✅ .env.template (from this deployment package)
```

---

### **STEP 2: Organize Files**

**2.1 Create Subfolders** (inside `/livermore/`):
```
📁 brokers
📁 crypto
📁 data
📁 logs
📁 tmp
```

**2.2 Move Files:**

**Into `brokers/` folder:**
- mt5_connector.py
- broker_configs.py
- pair_classifier.py
- Create empty file: `__init__.py`

**Into `crypto/` folder:**
- crypto_connector.py
- exchange_configs.py  
- crypto_classifier.py
- Create empty file: `__init__.py`

---

### **STEP 3: Setup Python Application**

**3.1 Find Python Setup**
Look for one of these in control panel:
- "Setup Python App"
- "Python Selector"
- "Application Manager"
- "Python Applications"

**3.2 Create Application**
Click "Create Application" or "+ New Application"

**3.3 Fill Form:**
```
Python Version: 3.8 or higher (select highest available)

Application Root: /home/YOURUSERNAME/public_html/livermore
(Replace YOURUSERNAME with your actual username)

Application URL: adekay.com/livermore
OR: /livermore

Application Startup File: passenger_wsgi.py

Application Entry Point: application
```

**3.4 Install Packages**
In the Python app settings, find "Install packages" or "Run pip install":
```
Flask flask-cors pandas numpy ccxt python-dotenv requests
```

Click "Install" and wait for completion.

---

### **STEP 4: Create .env Configuration**

**4.1 Go to File Manager**
Navigate to: `/public_html/livermore/`

**4.2 Create .env file**
- Click "New File"
- Name: `.env`
- Paste this content:

```env
# Flask Configuration
FLASK_ENV=production
SECRET_KEY=change-me-to-random-string-abc123xyz

# Notifications
ENABLE_EMAIL=True
ENABLE_TELEGRAM=True
MIN_PRIORITY_NOTIFY=85

NOTIFY_STAGE1_BUY=True
NOTIFY_STAGE1_SELL=True

# Email (Gmail)
SMTP_SERVER=smtp.gmail.com
SMTP_PORT=587
SENDER_EMAIL=your-email@gmail.com
SENDER_PASSWORD=your-gmail-app-password
RECIPIENT_EMAIL=alerts@gmail.com

# Telegram
TELEGRAM_BOT_TOKEN=your-bot-token-here
TELEGRAM_CHAT_ID=your-chat-id-here

# Crypto Exchange Keys (optional)
BINANCE_API_KEY=
BINANCE_API_SECRET=

OKX_API_KEY=
OKX_API_SECRET=
OKX_PASSWORD=
```

**4.3 Update Values**
- Change `SECRET_KEY` to any random string
- Add your real email and password
- Add Telegram bot token and chat ID
- Add crypto API keys if using

**4.4 Save**

---

### **STEP 5: Setup Cron Jobs**

**5.1 Find Cron Jobs**
Control Panel → Look for "Cron Jobs" or "Scheduled Tasks"

**5.2 Add Cron Job #1 - Daily Restart**
```
Minute: 0
Hour: 4
Day: *
Month: *
Weekday: *

Command:
touch /home/YOURUSERNAME/public_html/livermore/tmp/restart.txt
```

**5.3 Add Cron Job #2 - Keepalive (Optional)**
```
Minute: */5
Hour: *
Day: *
Month: *
Weekday: *

Command:
curl -s http://adekay.com/livermore/ > /dev/null
```

---

### **STEP 6: Start Your App**

**Option 1: Touch restart.txt (Recommended)**
1. File Manager → `/livermore/tmp/`
2. Create empty file: `restart.txt`
3. Done! Passenger will auto-restart

**Option 2: Restart Button**
1. Python Setup → Find your app
2. Click "Restart" button

---

### **STEP 7: Test**

**Open in browser:**
```
http://adekay.com/livermore
```

**You should see the scanner dashboard!** 🎉

**Test APIs:**
```
http://adekay.com/livermore/api/connections
http://adekay.com/livermore/api/symbols
```

---

## 🔄 How to Restart App (No SSH!)

### Method 1: Restart File (Fastest)
```
File Manager → /livermore/tmp/ → 
Delete restart.txt → Create new restart.txt
```

### Method 2: Python Setup
```
Control Panel → Python Setup → 
Find app → Click "Restart"
```

### Method 3: Modify File
```
File Manager → Edit any .py file → 
Add a space → Save
```

Passenger detects file changes and auto-restarts!

---

## 📊 View Logs (No SSH!)

### File Manager Method:
```
File Manager → /livermore/logs/ → 
Right-click log file → View or Download
```

### Control Panel Method:
```
Look for "Error Logs" in control panel → 
Select your domain → View logs
```

---

## 🐛 Troubleshooting

### "Can't find Python Setup"?
**Look for these names:**
- Application Manager
- Python Selector  
- Setup Python App
- Web Applications
- Python/WSGI Apps

**Still can't find it?**
Contact Jupiter support: "I need to setup a Python Flask application"

---

### "500 Internal Server Error"

**Check 1: passenger_wsgi.py exists?**
```
File Manager → /livermore/ → 
Should see passenger_wsgi.py
```

**Check 2: .env file correct?**
```
File Manager → /livermore/ → 
Open .env → Check no typos
```

**Check 3: Packages installed?**
```
Python Setup → Your app → 
Re-install: Flask flask-cors pandas numpy ccxt python-dotenv
```

**Check 4: Restart app**
```
Touch restart.txt method above
```

---

### "Application Failed to Start"

**Wrong Python version?**
```
Python Setup → Change to 3.8 or higher
```

**Missing packages?**
```
Python Setup → Install all packages:
Flask flask-cors pandas numpy ccxt python-dotenv requests
```

**Wrong paths?**
```
Open passenger_wsgi.py in File Manager
Check path: /home/YOURUSERNAME/public_html/livermore
```

---

### "Module not found" errors

**Install missing module:**
```
Python Setup → Your app → 
Pip install: module-name
```

**Example for werkzeug:**
```
pip install werkzeug
```

---

### Dashboard loads but no data?

**This is normal!**
- MT5 won't work on Linux hosting
- Use Crypto exchanges instead
- Add Binance/OKX API keys to .env

---

## 📁 Final File Structure

```
public_html/livermore/
├── passenger_wsgi.py    ← Passenger entry
├── app.py              ← Main Flask app
├── scanner.py
├── indicators.py
├── murrey.py
├── unified_connector.py
├── telegram_notifier.py
├── email_notifier.py
├── dashboard.html
├── scanner.css
├── requirements.txt
├── .env                ← Your config
├── .htaccess
├── brokers/
│   ├── __init__.py
│   ├── mt5_connector.py
│   ├── broker_configs.py
│   └── pair_classifier.py
├── crypto/
│   ├── __init__.py
│   ├── crypto_connector.py
│   ├── exchange_configs.py
│   └── crypto_classifier.py
├── data/
├── logs/
└── tmp/
    └── restart.txt     ← Touch to restart
```

---

## ✅ Deployment Checklist

- [ ] All files uploaded
- [ ] Subfolders created
- [ ] Files organized
- [ ] Python app created
- [ ] Packages installed
- [ ] .env configured
- [ ] Cron job added
- [ ] restart.txt created
- [ ] Dashboard accessible
- [ ] No errors in logs

---

## 🎯 Quick Commands Reference

**Restart App:**
```
Touch: /livermore/tmp/restart.txt
```

**Check Status:**
```
Visit: http://adekay.com/livermore
```

**View Logs:**
```
File Manager → /livermore/logs/
```

**Update Code:**
```
1. Upload new file
2. Touch restart.txt
3. Done!
```

---

## 🆘 Common Issues

### Issue: "Can't access /livermore URL"

**Solution:**
1. Check .htaccess exists in /livermore/
2. Make sure Python app URL is set to: `adekay.com/livermore`
3. Restart app

---

### Issue: "502 Bad Gateway"

**Solution:**
1. Touch restart.txt
2. Check Python Setup shows app as "Running"
3. Check error logs

---

### Issue: "ImportError: No module named 'flask'"

**Solution:**
1. Go to Python Setup
2. Find your app
3. Reinstall: `Flask flask-cors pandas numpy ccxt python-dotenv`

---

### Issue: Cron job not working

**Solution:**
1. Make sure you replaced YOURUSERNAME
2. Check cron job format is correct
3. Test command manually in Python Setup terminal (if available)

---

## 📞 Get Help

**Jupiter Support:**
- Open support ticket
- Mention: "Python Flask application setup"
- Ask for: Passenger and mod_wsgi support

**What to send them:**
1. Your domain: adekay.com
2. App location: /public_html/livermore/
3. Error message from logs

---

## 🎉 Success!

Once you see the dashboard at `http://adekay.com/livermore`, you're done!

**Next steps:**
1. Add crypto exchange connections
2. Select symbols to scan
3. Setup email/Telegram notifications
4. Start scanning!

---

**Happy Trading!** 📈💰
