# 🚀 JUPITER HOSTING - ONE-PAGE SETUP GUIDE

## ⚡ 5-MINUTE SETUP (Visual Guide)

---

### 📁 STEP 1: UPLOAD FILES (2 minutes)

```
1. Login → Jupiter Control Panel
2. Click: [File Manager] icon
3. Navigate: public_html/
4. Click: [New Folder] → Type: livermore → [Create]
5. Open: livermore/ folder
6. Click: [Upload]
7. Select ALL these files:
   ✅ app.py, scanner.py, indicators.py, murrey.py
   ✅ unified_connector.py, telegram_notifier.py, email_notifier.py
   ✅ mt5_connector.py, broker_configs.py, pair_classifier.py
   ✅ crypto_connector.py, exchange_configs.py, crypto_classifier.py
   ✅ dashboard.html, scanner.css
   ✅ passenger_wsgi.py (from deployment package)
   ✅ .htaccess (from deployment package - rename after upload)
   ✅ .env.template (from deployment package)
8. Click: [Upload]
9. Wait for completion ✓
```

**Create 5 subfolders inside /livermore/:**
```
[New Folder] → brokers
[New Folder] → crypto
[New Folder] → data
[New Folder] → logs
[New Folder] → tmp
```

**Move files:**
- **To brokers/**: mt5_connector.py, broker_configs.py, pair_classifier.py
- **To crypto/**: crypto_connector.py, exchange_configs.py, crypto_classifier.py

**Create empty __init__.py files:**
- One in brokers/
- One in crypto/

---

### 🐍 STEP 2: SETUP PYTHON APP (1 minute)

```
1. Control Panel → Find: "Setup Python App" or "Python Selector"
2. Click: [Create Application] or [+ New App]
3. Fill form:

   Python Version: [Select 3.8 or higher ▼]
   
   Application Root: /home/YOURUSERNAME/public_html/livermore
   (Replace YOURUSERNAME - find it by clicking "Home" in File Manager)
   
   Application URL: adekay.com/livermore
   
   Application Startup: passenger_wsgi.py
   
   Entry Point: application

4. Click: [Create] or [Save]
5. Wait for virtual environment creation ✓
```

**Install packages:**
```
Find: "Install packages" or "Run pip install"
Paste: Flask flask-cors pandas numpy ccxt python-dotenv requests
Click: [Install]
Wait: ✓
```

---

### ⚙️ STEP 3: CONFIGURE .ENV (1 minute)

```
1. File Manager → /livermore/
2. Find: .env.template → Right-click → [Copy]
3. Paste → Rename to: .env
4. Right-click .env → [Edit]
5. Change these values:

SECRET_KEY=your-random-string-abc123xyz

SENDER_EMAIL=your-email@gmail.com
SENDER_PASSWORD=your-gmail-app-password
RECIPIENT_EMAIL=alerts@gmail.com

TELEGRAM_BOT_TOKEN=your-telegram-bot-token
TELEGRAM_CHAT_ID=your-telegram-chat-id

6. Click: [Save]
```

---

### ⏰ STEP 4: ADD CRON JOB (30 seconds)

```
1. Control Panel → Find: "Cron Jobs"
2. Click: [Add Cron Job]
3. Fill:

   Minute: 0
   Hour: 4
   Day: *
   Month: *
   Weekday: *
   
   Command:
   touch /home/YOURUSERNAME/public_html/livermore/tmp/restart.txt

4. Click: [Add] or [Save]
```

---

### 🚀 STEP 5: START APP (30 seconds)

```
1. File Manager → /livermore/tmp/
2. Click: [New File]
3. Name: restart.txt
4. Leave empty → Click: [Create]

✓ App starts automatically!
```

---

### ✅ STEP 6: TEST (10 seconds)

```
Open browser:
http://adekay.com/livermore

✓ You should see the scanner dashboard!
```

---

## 🔄 HOW TO RESTART (Choose one)

### Option 1: Touch File (Fastest)
```
File Manager → /livermore/tmp/ → 
Delete restart.txt → Create new restart.txt
```

### Option 2: Restart Button
```
Python Setup → Your app → [Restart] button
```

### Option 3: Edit File
```
File Manager → Edit any .py file → Add space → Save
(Passenger detects change and restarts)
```

---

## 📊 HOW TO VIEW LOGS

```
File Manager → /livermore/logs/ → 
Right-click newest .log file → [View] or [Download]
```

---

## 🐛 IF SOMETHING GOES WRONG

### Can't find "Setup Python App"?
```
Look for: "Python Selector", "Application Manager", 
"Web Applications", or "Python Applications"

Still not found? → Open support ticket:
"I need to setup a Python Flask application"
```

### "500 Internal Server Error"?
```
1. Check: passenger_wsgi.py exists in /livermore/
2. Check: .env has all settings
3. Python Setup → Reinstall packages
4. Touch restart.txt
```

### "Module not found"?
```
Python Setup → Your app → 
Pip install: missing-module-name
Example: pip install flask
```

### Dashboard loads but empty?
```
Normal! MT5 won't work on Linux hosting.
Use crypto exchanges:
1. Add Binance/OKX API keys to .env
2. Restart app
3. Add crypto connections in dashboard
```

---

## 📁 FINAL FILE STRUCTURE

```
public_html/livermore/
├── passenger_wsgi.py    ← Entry point
├── app.py              ← Flask app
├── .env                ← Your config ⚙️
├── .htaccess           ← Passenger config
├── dashboard.html      ← Web UI
├── scanner.css         ← Styles
├── brokers/
│   ├── __init__.py
│   └── [3 broker files]
├── crypto/
│   ├── __init__.py
│   └── [3 crypto files]
├── data/
├── logs/
└── tmp/
    └── restart.txt     ← Touch to restart 🔄
```

---

## ✅ CHECKLIST

- [ ] All files uploaded to /livermore/
- [ ] Subfolders created
- [ ] Files moved to brokers/ and crypto/
- [ ] Python app created
- [ ] Packages installed
- [ ] .env configured
- [ ] Cron job added
- [ ] restart.txt created
- [ ] http://adekay.com/livermore works!

---

## 🎯 QUICK REFERENCE

| Action | Steps |
|--------|-------|
| **Restart** | Touch /tmp/restart.txt |
| **View logs** | File Manager → /logs/ |
| **Update code** | Upload new file → Touch restart.txt |
| **Check status** | Visit http://adekay.com/livermore |
| **Add package** | Python Setup → pip install package |

---

## 📞 SUPPORT

**Need help?**
1. Check logs in /livermore/logs/
2. Open Jupiter support ticket
3. Include: domain, app path, error message

---

## 🎉 DONE!

Your scanner is now live at:
**http://adekay.com/livermore**

**Next steps:**
1. Add crypto exchange connections (Binance, OKX)
2. Select symbols to scan
3. Run your first scan!

**Happy Trading!** 📈💰
