#!/usr/bin/env python3
"""
Passenger WSGI file for Jupiter Hosting
This file tells Passenger how to run your Flask app
"""
import sys
import os

# Add your application directory to the Python path
sys.path.insert(0, os.path.expanduser('~/public_html/livermore'))

# Load environment variables from .env
from dotenv import load_dotenv
load_dotenv(os.path.join(os.path.dirname(__file__), '.env'))

# Import your Flask app
from app import app as application

# This is what Passenger will use
if __name__ == '__main__':
    application.run()
