from flask import Flask, render_template, jsonify, send_from_directory
from sniper_engine import check_sniper_conditions
from apscheduler.schedulers.background import BackgroundScheduler
import requests
import smtplib
from email.mime.text import MIMEText
import logging
import sys
import os

# Configure Logging
logging.basicConfig(stream=sys.stderr, level=logging.INFO)
logger = logging.getLogger('SniperApp')

app = Flask(__name__)

# --- CREDENTIALS ---
TELEGRAM_TOKEN = "8238832364:AAGW51FG4KlL1prIH06_mkhdG0ZvpVs6_f0"
TELEGRAM_CHAT_ID = "6984434604"
EMAIL_SENDER = "adekolagafat@gmail.com"
EMAIL_PASSWORD = "qwzc avdh fzpi osea"
EMAIL_RECEIVER = "adekolagafat@gmail.com"

# Cache results
latest_scan_results = []

def send_telegram(message):
    if "YOUR_BOT" in TELEGRAM_TOKEN: return
    url = f"https://api.telegram.org/bot{TELEGRAM_TOKEN}/sendMessage"
    try:
        requests.post(url, data={"chat_id": TELEGRAM_CHAT_ID, "text": message}, timeout=10)
    except Exception as e:
        logger.error(f"Telegram Failed: {e}")

def send_email(subject, body):
    if "your_email" in EMAIL_SENDER: return
    msg = MIMEText(body)
    msg['Subject'] = subject
    msg['From'] = EMAIL_SENDER
    msg['To'] = EMAIL_RECEIVER
    try:
        with smtplib.SMTP_SSL('smtp.gmail.com', 465) as server:
            server.login(EMAIL_SENDER, EMAIL_PASSWORD)
            server.send_message(msg)
    except Exception as e:
        logger.error(f"Email Failed: {e}")

def scheduled_job():
    global latest_scan_results
    logger.info("Starting scheduled scan...")
    try:
        results = check_sniper_conditions()
        latest_scan_results = results
        
        for item in results:
            if "SNIPER" in item['signal']:
                alert_msg = (f"🚨 {item['pair']} ALERT 🚨\n\n"
                             f"Signal: {item['signal']}\n"
                             f"Reason: {item['reason']}\n"
                             f"Price: {item['data'].get('Price', 'N/A')}\n"
                             f"Time: {item['timestamp']}")
                send_telegram(alert_msg)
                send_email(f"Sniper Alert: {item['pair']}", alert_msg)
    except Exception as e:
        logger.error(f"Scan failed: {e}")

# Start Scheduler
try:
    scheduler = BackgroundScheduler()
    scheduler.add_job(func=scheduled_job, trigger="interval", minutes=15)
    scheduler.start()
except Exception as e:
    logger.error(f"Scheduler failed: {e}")

# --- ROUTES ---

@app.route('/')
def index():
    return render_template('index.html')

@app.route('/api/scan')
def scan_api():
    if not latest_scan_results:
        scheduled_job()
    return jsonify(latest_scan_results)

@app.route('/api/force_scan')
def force_scan():
    scheduled_job()
    return jsonify(latest_scan_results)

# --- PWA ROUTES (The Fix) ---
# This tells Flask: "When someone asks for /sw.js, serve the file from the /static folder"
@app.route('/manifest.json')
def manifest():
    static_folder = os.path.join(app.root_path, 'static')
    return send_from_directory(static_folder, 'manifest.json')

@app.route('/sw.js')
def service_worker():
    static_folder = os.path.join(app.root_path, 'static')
    return send_from_directory(static_folder, 'sw.js', mimetype='application/javascript')

# Required for cPanel
application = app

if __name__ == '__main__':
    app.run()