const CACHE_NAME = 'sniper-v3-cache';
const URLS_TO_CACHE = [
    '/snipper_project/',
    'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css',
    'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css',
    'https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;600&family=Inter:wght@400;700&display=swap'
];

// Install Event: Cache static assets
self.addEventListener('install', (event) => {
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then((cache) => {
                return cache.addAll(URLS_TO_CACHE);
            })
    );
});

// Fetch Event: Network First for API, Cache First for Assets
self.addEventListener('fetch', (event) => {
    const reqUrl = new URL(event.request.url);

    // 1. API Requests: ALWAYS go to network (Live Data)
    if (reqUrl.pathname.includes('/api/')) {
        event.respondWith(
            fetch(event.request).catch(() => {
                // Optional: Return simple JSON error if offline
                return new Response(JSON.stringify({ error: "Offline" }), {
                    headers: { "Content-Type": "application/json" }
                });
            })
        );
        return;
    }

    // 2. Static Assets: Try Cache, then Network
    event.respondWith(
        caches.match(event.request)
            .then((response) => {
                return response || fetch(event.request);
            })
    );
});

// Activate Event: Clean up old caches
self.addEventListener('activate', (event) => {
    event.waitUntil(
        caches.keys().then((cacheNames) => {
            return Promise.all(
                cacheNames.map((cacheName) => {
                    if (cacheName !== CACHE_NAME) {
                        return caches.delete(cacheName);
                    }
                })
            );
        })
    );
});